<?php

/**
 * Calls the class on the post edit screen.
 */
function hitmag_pro_metaboxes_call() {
    new HitMag_Pro_Metaboxes();
}
 
if ( is_admin() ) {
    add_action( 'load-post.php',     'hitmag_pro_metaboxes_call' );
    add_action( 'load-post-new.php', 'hitmag_pro_metaboxes_call' );
}
 
/**
 * Adds a Layout select meta box to posts and pages.
 */
class HitMag_Pro_Metaboxes {
 
    /**
     * Hook into the appropriate actions when the class is constructed.
     */
    public function __construct() {
        add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
        add_action( 'save_post',      array( $this, 'save'         ) );
    }
 
    /**
     * Adds the meta box container.
     */
    public function add_meta_box( $post_type ) {
        // Limit meta box to certain post types.
        $post_types = array( 'post', 'page' );
 
        if ( in_array( $post_type, $post_types ) ) {
            add_meta_box(
                'hitmag_pro_layout_meta',
                __( 'Select Layout', 'hitmag-pro' ),
                array( $this, 'render_meta_box_content' ),
                $post_type,
                'side',
                'default'
            );
        }

        add_meta_box(
            'hitmag_pro_post_meta',
            __( 'Post Settings', 'hitmag-pro' ),
            array( $this, 'render_post_meta_box_content' ),
            'post',
            'normal',
            'default'
        );

        add_meta_box(
            'hitmag_pro_featured_video',
            __( 'Featured Video', 'hitmag-pro' ),
            array( $this, 'render_featured_video_content' ),
            'post',
            'side',
            'default'
        );

    }
 
    /**
     * Save the meta when the post is saved.
     *
     * @param int $post_id The ID of the post being saved.
     */
    public function save( $post_id ) {
 
        /*
         * We need to verify this came from the our screen and with proper authorization,
         * because save_post can be triggered at other times.
         */
 
        // Check if our nonce is set.
        if ( ! isset( $_POST['hitmag_pro_layout_metabox_nonce'] ) ) {
            return $post_id;
        }
 
        $nonce = $_POST['hitmag_pro_layout_metabox_nonce'];
 
        // Verify that the nonce is valid.
        if ( ! wp_verify_nonce( $nonce, 'hitmag_pro_layout_metabox' ) ) {
            return $post_id;
        }
 
        /*
         * If this is an autosave, our form has not been submitted,
         * so we don't want to do anything.
         */
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return $post_id;
        }
 
        // Check the user's permissions.
        if ( 'page' == $_POST['post_type'] ) {
            if ( ! current_user_can( 'edit_page', $post_id ) ) {
                return $post_id;
            }
        } else {
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return $post_id;
            }
        }
 
        /* OK, it's safe for us to save the data now. */
 
        // Sanitize the user input.
        $selected_layout = sanitize_text_field( $_POST['hitmag_pro_layout'] );
 
        // Update the meta field.
        update_post_meta( $post_id, '_hitmag_pro_layout_meta', $selected_layout );


        /* Post Layout Style */
        ////////////////////////////////////////////////////////////////


        // Check if our nonce is set.
        if ( ! isset( $_POST['hitmag_pro_post_layout_nonce'] ) ) {
            return $post_id;
        }
 
        $nonce = $_POST['hitmag_pro_post_layout_nonce'];
 
        // Verify that the nonce is valid.
        if ( ! wp_verify_nonce( $nonce, 'hitmag_pro_post_layout' ) ) {
            return $post_id;
        }
 
        /*
         * If this is an autosave, our form has not been submitted,
         * so we don't want to do anything.
         */
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return $post_id;
        }
 
        // Check the user's permissions.
        if ( 'page' == $_POST['post_type'] ) {
            if ( ! current_user_can( 'edit_page', $post_id ) ) {
                return $post_id;
            }
        } else {
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return $post_id;
            }
        }
 
        /* OK, it's safe for us to save the data now. */
 
        // Sanitize the user input.
        $selected_post_layout = sanitize_text_field( $_POST['hitmag_pro_post_layout'] );
 
        // Update the meta field.
        update_post_meta( $post_id, '_hitmag_pro_post_layout', $selected_post_layout );        

        

        /* Post Layout Style */
        ////////////////////////////////////////////////////////////////

        // Check if our nonce is set.
        if ( ! isset( $_POST['hitmag_pro_video_metabox_nonce'] ) ) {
            return $post_id;
        }
 
        $nonce = $_POST['hitmag_pro_video_metabox_nonce'];
 
        // Verify that the nonce is valid.
        if ( ! wp_verify_nonce( $nonce, 'hitmag_pro_video_metabox' ) ) {
            return $post_id;
        }
 
        /*
         * If this is an autosave, our form has not been submitted,
         * so we don't want to do anything.
         */
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return $post_id;
        }
 
        // Check the user's permissions.
        if ( 'page' == $_POST['post_type'] ) {
            if ( ! current_user_can( 'edit_page', $post_id ) ) {
                return $post_id;
            }
        } else {
            if ( ! current_user_can( 'edit_post', $post_id ) ) {
                return $post_id;
            }
        }
 
        /* OK, it's safe for us to save the data now. */
 
        // Sanitize the user input.
        $video_url = esc_url_raw( $_POST['hitmag_pro_video_meta'] );
 
        // Update the meta field.
        update_post_meta( $post_id, '_hitmag_pro_video_meta', $video_url );        


    }
 
 
    /**
     * Render Meta Box content.
     *
     * @param WP_Post $post The post object.
     */
    public function render_meta_box_content( $post ) {
 
        // Add an nonce field so we can check for it later.
        wp_nonce_field( 'hitmag_pro_layout_metabox', 'hitmag_pro_layout_metabox_nonce' );
 
        $selected_layout = get_post_meta( $post->ID, '_hitmag_pro_layout_meta', true );
 
        // Display the form, using the current value.
        if( empty( $selected_layout) ) { $selected_layout = 'th-default-layout'; }
        ?>

        <input type="radio" id="th-default-layout" name="hitmag_pro_layout" value="th-default-layout" <?php checked( 'th-default-layout', $selected_layout ); ?> />
        <label for="th-default-layout" class="post-format-icon"><?php _e( 'Default Layout', 'hitmag-pro' ); ?></label><br/>
        
        <input type="radio" id="th-right-sidebar" name="hitmag_pro_layout" value="th-right-sidebar" <?php checked( 'th-right-sidebar', $selected_layout ); ?> />
        <label for="th-right-sidebar" class="post-format-icon"><?php _e( 'Right Sidebar', 'hitmag-pro' ); ?></label><br/>
        
        <input type="radio" id="th-left-sidebar" name="hitmag_pro_layout" value="th-left-sidebar" <?php checked( 'th-left-sidebar', $selected_layout ); ?> />
        <label for="th-left-sidebar" class="post-format-icon"><?php _e( 'Left Sidebar', 'hitmag-pro' ); ?></label><br/>
        
        <input type="radio" id="th-no-sidebar" name="hitmag_pro_layout" value="th-no-sidebar" <?php checked( 'th-no-sidebar', $selected_layout ); ?> />
        <label for="th-no-sidebar" class="post-format-icon"><?php _e( 'Full Width', 'hitmag-pro' ); ?></label><br/>
        
        <input type="radio" id="th-content-centered" name="hitmag_pro_layout" value="th-content-centered" <?php checked( 'th-content-centered', $selected_layout ); ?> />
        <label for="th-content-centered" class="post-format-icon"><?php _e( 'Full Width Content Centered.', 'hitmag-pro' ); ?></label><br/>
        
        <?php
    }

    /**
     * Render Post Metabox content.
     */
    public function render_post_meta_box_content( $post ) {

        wp_nonce_field( 'hitmag_pro_post_layout', 'hitmag_pro_post_layout_nonce' );

        $selected_layout = get_post_meta( $post->ID, '_hitmag_pro_post_layout', true );

        if( empty( $selected_layout ) ) { $selected_layout = 'post-style-default'; } ?>

        <p><b>Post Template:</b></p>

        <input class="th-input-hidden th-post-radio-img" type="radio" id="post-style-default" name="hitmag_pro_post_layout" value="post-style-default" <?php checked( 'post-style-default', $selected_layout ); ?> />
        <label for="post-style-default" class="th-post-format-icon">
            <img src="<?php echo get_template_directory_uri() . '/inc/customizer/assets/imgs/style-default.jpg'; ?>" />
        </label>

        <input class="th-input-hidden th-post-radio-img" type="radio" id="post-style-1" name="hitmag_pro_post_layout" value="post-style-1" <?php checked( 'post-style-1', $selected_layout ); ?> />
        <label for="post-style-1" class="th-post-format-icon">
            <img src="<?php echo get_template_directory_uri() . '/inc/customizer/assets/imgs/style-1.jpg'; ?>" />
        </label>
        
        <input class="th-input-hidden th-post-radio-img" type="radio" id="post-style-2" name="hitmag_pro_post_layout" value="post-style-2" <?php checked( 'post-style-2', $selected_layout ); ?> />
        <label for="post-style-2" class="th-post-format-icon">
            <img src="<?php echo get_template_directory_uri() . '/inc/customizer/assets/imgs/style-2.jpg'; ?>" />
        </label>
        
        <input class="th-input-hidden th-post-radio-img" type="radio" id="post-style-3" name="hitmag_pro_post_layout" value="post-style-3" <?php checked( 'post-style-3', $selected_layout ); ?> />
        <label for="post-style-3" class="th-post-format-icon">
            <img src="<?php echo get_template_directory_uri() . '/inc/customizer/assets/imgs/style-3.jpg'; ?>" />
        </label>

        <input class="th-input-hidden th-post-radio-img" type="radio" id="post-style-4" name="hitmag_pro_post_layout" value="post-style-4" <?php checked( 'post-style-4', $selected_layout ); ?> />
        <label for="post-style-4" class="th-post-format-icon">
            <img src="<?php echo get_template_directory_uri() . '/inc/customizer/assets/imgs/style-4.jpg'; ?>" />
        </label>       

        <?php

    }

    /**
     * Render featured video content.
     */

    public function render_featured_video_content( $post ) {
        // Add an nonce field so we can check for it later.
        wp_nonce_field( 'hitmag_pro_video_metabox', 'hitmag_pro_video_metabox_nonce' );
 
        $video_url = get_post_meta( $post->ID, '_hitmag_pro_video_meta', true ); 

        if ( empty( $video_url ) ) { $video_url = ""; }

        ?>

        <p>
            <label for="hm-featured-video" class="widefat"><?php _e( 'Featured Video URL', 'hitmag-pro' )?></label>
            <input type="text" class="widefat" name="hitmag_pro_video_meta" id="hm-featured-video" value="<?php echo esc_url( $video_url ); ?>" />
        </p>
        <p>
            <?php _e( '<b>Note:</b> This video displays only on <b>Style 3</b> and <b>Style 4</b> post templates only.' ) ?>
        </p>

    <?php

    }


}