<?php
/**
 * HitMag Theme Customizer
 *
 * @package HitMag Pro
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 * Add panels and sections of the theme.
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function hitmag_pro_sections_register( $wp_customize ) {

	require( get_template_directory() . '/inc/customizer/custom-controls/control-category-dropdown.php' );

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
	$wp_customize->get_section( 'header_image' )->panel 		= 'hitmag-pro-header-options';
	$wp_customize->get_section( 'header_image' )->priority 		= 2;
	$wp_customize->get_section( 'colors' )->panel 				= 'hitmag-pro-typography';
    $wp_customize->get_control( 'background_color' )->section 	= 'hitmag_pro_main_colors';
    $wp_customize->get_control( 'background_color' )->priority 	= 1;
    $wp_customize->get_control( 'header_textcolor' )->section 	= 'hitmag_pro_main_colors';
    $wp_customize->get_control( 'header_textcolor' )->priority 	= 2;

	/**
	 * Add panels
	 */
	$wp_customize->add_panel( 'hitmag-pro-header-options', array(
		'priority'    => 30,
		'title'       => __( 'Header options', 'hitmag-pro' ),
	) );
	$wp_customize->add_panel( 'hitmag-pro-post-options', array(
		'priority'    => 31,
		'title'       => __( 'Post options', 'hitmag-pro' ),
	) );	
	$wp_customize->add_panel( 'hitmag-pro-typography', array(
		'priority'    => 33,
		'title'       => __( 'Typography Options', 'hitmag-pro' ),
	) );
	$wp_customize->add_panel( 'hitmag-pro-colors', array(
		'priority'    => 34,
		'title'       => __( 'Colors', 'hitmag-pro' ),
	) );	

	/**
	 * Add sections
	 */

	// Top Bar Options
	$wp_customize->add_section( 'hitmag_pro_gen_options', array(
		'title'       	=> __( 'General Settings', 'hitmag-pro' ),
		'priority'    	=> 25
	) );	

	// Top Bar Options
	$wp_customize->add_section( 'top_bar', array(
		'title'       	=> __( 'Top Bar', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-header-options',
		'priority'    	=> 1
	) );	 

	$wp_customize->add_section( 'header_settings', array(
		'title'       	=> __( 'Header Settings', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-header-options',
		'priority'    	=> 1
	) );

	$wp_customize->add_section( 'header_image_options', array(
		'title'       	=> __( 'Header Image Options', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-header-options',
		'priority'    	=> 3
	) );	

	// Slider Settings
	$wp_customize->add_section( 'hitmag_pro_slider_settings', array(
		'title'       	=> __( 'Slider Settings', 'hitmag-pro' ),
		'priority'    	=> 28
	) );

	// Blog Options
	$wp_customize->add_section( 'hitmag_pro_blog_options', array(
		'title'       	=> __( 'Blog options', 'hitmag-pro' ),
		'description' 	=> __( 'These options affect to blog posts listing page and archives like category and tags.', 'hitmag-pro' ),
		'priority'    	=> 30
	) );

	// Post Options
	/*$wp_customize->add_section( 'hitmag_pro_post_options', array(
		'title'       	=> __( 'Post options', 'hitmag-pro' ),
		'description' 	=> __( 'These options affect only to single post articles.', 'hitmag-pro' ),
		'priority'    	=> 31
	) );*/
	$wp_customize->add_section( 'hitmag_pro_post_layout', array(
		'title'       	=> __( 'Post Layout', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-post-options',
		'priority'    	=> 1
	) );
	$wp_customize->add_section( 'hitmag_pro_post_meta', array(
		'title'       	=> __( 'Post Meta', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-post-options',
		'priority'    	=> 2
	) );	
	$wp_customize->add_section( 'hitmag_pro_post_sharing', array(
		'title'       	=> __( 'Social Sharing Icons', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-post-options',
		'priority'    	=> 3
	) );	
	$wp_customize->add_section( 'hitmag_pro_post_thumbnail', array(
		'title'       	=> __( 'Featured Image', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-post-options',
		'priority'    	=> 4
	) );	
	$wp_customize->add_section( 'hitmag_pro_post_navigation', array(
		'title'       	=> __( 'Posts Navigation', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-post-options',
		'priority'    	=> 5
	) );		
	$wp_customize->add_section( 'hitmag_pro_post_author', array(
		'title'       	=> __( 'Author Details Box', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-post-options',
		'priority'    	=> 6
	) );
	$wp_customize->add_section( 'hitmag_pro_post_related', array(
		'title'       	=> __( 'Related Posts', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-post-options',
		'priority'    	=> 7
	) );	


	// Page Options
	$wp_customize->add_section( 'hitmag_pro_page_options', array(
		'title'       	=> __( 'Page options', 'hitmag-pro' ),
		'description' 	=> __( 'These opitons affect only to pages.', 'hitmag-pro' ),
		'priority'    	=> 32
	) );	
	// Typography Options
	$wp_customize->add_section( 'hitmag_pro_main_typo', array(
		'title'       	=> __( 'Main Typography', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-typography',
		'priority'    	=> 1
	) );	
	$wp_customize->add_section( 'hitmag_pro_heading_typo', array(
		'title'       	=> __( 'Heading Typography', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-typography',
		'priority'    	=> 2
	) );	

	// Theme colors
	$wp_customize->add_section( 'hitmag_pro_main_colors', array(
		'title'       	=> __( 'Theme Main Colors', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-colors',
		'priority'    	=> 1
	) );

	// Link Colors
	$wp_customize->add_section( 'hitmag_pro_link_colors', array(
		'title'       	=> __( 'Links/Buttons Colors', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-colors',
		'priority'    	=> 2
	) );

	// Main navigation colors
	$wp_customize->add_section( 'hitmag_pro_mainnav_colors', array(
		'title'       	=> __( 'Main Navigation Colors', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-colors',
		'priority'    	=> 3
	) );

	// Top navigation colors
	$wp_customize->add_section( 'hitmag_pro_topnav_colors', array(
		'title'       	=> __( 'Top Bar/Navigation Colors', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-colors',
		'priority'    	=> 4
	) );

	// Footer colors
	$wp_customize->add_section( 'hitmag_pro_footer_colors', array(
		'title'       	=> __( 'Footer Colors', 'hitmag-pro' ),
		'panel'			=> 'hitmag-pro-colors',
		'priority'    	=> 5
	) );	

}
add_action( 'customize_register', 'hitmag_pro_sections_register' );


/**
 * Add fields to customizer
 */
function hitmag_pro_kirki_fields( $fields ) {

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'hitmag_pro_boxed_layout',
		'label'       => __( 'Boxed Layout', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_gen_options',
		'default'     => '1',
		'priority'    => 1,
		'choices'     => array(
			'on'  	=> esc_attr__( 'On', 'hitmag-pro' ),
			'off' 	=> esc_attr__( 'Off', 'hitmag-pro' ),
		),
	);

	$fields[] = array(
		'type'        => 'checkbox',
		'settings'    => 'activate_sticky_sidebar',
		'label'       => __( 'Make Sidebar Sticky', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_gen_options',
		'default'     => '0',
		'priority'    => 2,
	);

	$fields[] = array(
		'type'     => 'textarea',
		'settings' => 'footer_copyright_text',
		'label'    => __( 'Footer Copyright Text.', 'hitmag-pro' ),
		'section'  => 'hitmag_pro_gen_options',
		'default'  => '',
		'priority' => 3,
	);

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'display_topbar',
		'label'       => __( 'Top Bar Show/Hide', 'hitmag-pro' ),
		'section'     => 'top_bar',
		'default'     => '1',
		'priority'    => 1,
		'choices'     => array(
			'on'  	=> esc_attr__( 'Show', 'hitmag-pro' ),
			'off' 	=> esc_attr__( 'Hide', 'hitmag-pro' ),
		),
	);

	$fields[] = array(
		'type'        		=> 'toggle',
		'settings'    		=> 'show_topbar_date',
		'label'       		=> __( 'Show date on topbar.', 'hitmag-pro' ),
		'section'     		=> 'top_bar',
		'default'     		=> '1',
		'priority'    		=> 10,
		'active_callback'	=> array(
			array(
				'setting'  => 'display_topbar',
				'operator' => '==',
				'value'    => true,
			),
		),
	);	

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'main_nav_sticky',
		'label'       => __( 'Sticky Navigation On/Off', 'hitmag-pro' ),
		'description' => __( 'Swich on if you want to enable sticky navigation.' ),
		'section'     => 'header_settings',
		'default'     => '1',
		'priority'    => 1,
		'choices'     => array(
			'on'  	=> esc_attr__( 'On', 'hitmag-pro' ),
			'off' 	=> esc_attr__( 'Off', 'hitmag-pro' ),
		),
	);	

	$fields[] = array(
		'type'        => 'radio',
		'settings'    => 'header_image_position',
		'label'       => __( 'Header Image Position', 'hitmag-pro' ),
		'section'     => 'header_image_options',
		'default'     => 'after-site-title',
		'priority'    => 1,		
		'choices'     => array(
			'after-site-title'   => array(
				esc_attr__( 'After site title and logo', 'hitmag-pro' )
			),
			'before-site-title' => array(
				esc_attr__( 'Before site title and logo', 'hitmag-pro' )
			),
			'after-main-nav'  => array(
				esc_attr__( 'After Main Navigation', 'hitmag-pro' )
			),
		),
	);	

	$fields[] = array(
		'type'        => 'checkbox',
		'settings'    => 'link_header_image',
		'label'       => __( 'Link header image to homepage.', 'hitmag-pro' ),
		'section'     => 'header_image_options',
		'default'     => '0',
		'priority'    => 2,
	);

	// Slider Settings.
	$fields[] = array(
		'type'        		=> 'custom',
		'settings'    		=> 'slider_notice',
		'label'       		=> __( 'Notice', 'hitmag-pro' ),
		'section'     		=> 'hitmag_pro_slider_settings',
		'default'     		=> '<div style="padding: 8px; background-color: #e74c3c; color: #fff; border-radius: 3px;">' . esc_html__( 'Slider displays on magazine homepage only.', 'hitmag-pro' ) . '</div>',
		'priority'    		=> 1,
		'active_callback' 	=> 'hitmag_pro_inactive_magazine'
	);

	$fields[] = array(
		'type'        		=> 'custom',
		'settings'    		=> 'slider_notice_url',
		'label'       		=> __( 'Create a magazine homepage.', 'hitmag-pro' ),
		'section'     		=> 'hitmag_pro_slider_settings',
		'default'     		=> '<a href="'. esc_url( admin_url( 'themes.php?page=about-hitmag-pro-theme&tab=magazine_homepage' ) ) .'" target="_blank">' . esc_html__('Learn How to create a magazine homepage','hitmag-pro') . '<a><br/><br/>',
		'priority'    		=> 2,
		'active_callback' 	=> 'hitmag_pro_inactive_magazine'
	);

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'show_slider',
		'label'       => __( 'Featured Slider', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_slider_settings',
		'default'     => '1',
		'priority'    => 3,
		'choices'     => array(
			'on'  => esc_attr__( 'On', 'hitmag-pro' ),
			'off' => esc_attr__( 'Off', 'hitmag-pro' ),
		),
	);

	$fields[] = array(
		'type'        => 'radio',
		'settings'    => 'slider_type',
		'label'       => __( 'Select the slider type.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_slider_settings',
		'default'     => 'posts-slider',
		'priority'    => 4,
		'choices'     => array(
			'posts-slider' 	=> esc_attr__( 'Posts Slider', 'hitmag-pro' ),
			'custom-slider' => esc_attr__( 'Custom Slider', 'hitmag-pro' ),
		),
		'active_callback'	=> array(
			array(
				'setting'  => 'show_slider',
				'operator' => '==',
				'value'    => true,
			),
		)
	);

	$fields[] = array(
		'type'        		=> 'hitmag-pro-category-dropdown',
		'settings'    		=> 'slider_category',
		'label'       		=> __( 'Select the category for slider posts', 'hitmag-pro' ),
		'section'     		=> 'hitmag_pro_slider_settings',
		'default'	  		=> '0',
		'priority'    		=> 5,
		'active_callback'	=> array(
			array(
				'setting'  => 'show_slider',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'slider_type',
				'operator' => '==',
				'value'    => 'posts-slider',
			),
		),
	);

	$fields[] = array(
		'type'     => 'number',
		'settings' => 'number_of_slides',
		'label'    => __( 'Number of slider posts.', 'hitmag-pro' ),
		'section'  => 'hitmag_pro_slider_settings',
		'default'  => 5,
		'priority' => 5,
		'choices'	=> array(
			'min'  => 1,
			'max'  => 15,
			'step' => 1,
		),
		'active_callback'	=> array(
			array(
				'setting'  => 'show_slider',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'slider_type',
				'operator' => '==',
				'value'    => 'posts-slider',
			),
		),		
	);

	$fields[] = array(
		'type'        => 'checkbox',
		'settings'    => 'display_slider_title',
		'label'       => __( 'Display Slider Title.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_slider_settings',
		'default'     => '1',
		'priority'    => 6,
		'active_callback' => array(
			array(
				'setting'  => 'show_slider',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'slider_type',
				'operator' => '==',
				'value'    => 'posts-slider',
			),
		),
	);

	$fields[] = array(
		'type'        => 'multicheck',
		'settings'    => 'slider_post_meta',
		'label'       => __( 'What post meta to display on slider?', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_slider_settings',
		'default'     => array('categories', 'date', 'author', 'comments'),
		'priority'    => 7,
		'choices'     => array(
			'categories' 	=> esc_attr__( 'Category List', 'hitmag-pro' ),
			'date' 			=> esc_attr__( 'Date', 'hitmag-pro' ),
			'author' 		=> esc_attr__( 'Author', 'hitmag-pro' ),
			'comments' 		=> esc_attr__( 'Comments Link', 'hitmag-pro' ),
		),
		'active_callback'	=> array(
			array(
				'setting'  => 'show_slider',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'slider_type',
				'operator' => '==',
				'value'    => 'posts-slider',
			),
		),
	);

	for( $i = 1; $i <= 10; $i++ ) {
		
		$fields[] = array(
			'type'        => 'image',
			'settings'    => 'slider_image_'.$i,
			'label'       => sprintf( __( 'Select slide %d image', 'hitmag-pro' ), $i ),
			'section'     => 'hitmag_pro_slider_settings',
			'default'     => '',
			'priority'    => 10,
			'active_callback'	=> array(
				array(
					'setting'  => 'show_slider',
					'operator' => '==',
					'value'    => true,
				),
				array(
					'setting'  => 'slider_type',
					'operator' => '==',
					'value'    => 'custom-slider',
				),
			),
		);

		$fields[] = array(
			'type'     => 'text',
			'settings' => 'slider_title_'.$i,
			'label'    => sprintf( __( 'Slide %d title', 'hitmag' ), $i ),
			'section'  => 'hitmag_pro_slider_settings',
			'default'  => "",
			'priority' => 10,
			'active_callback'	=> array(
				array(
					'setting'  => 'show_slider',
					'operator' => '==',
					'value'    => true,
				),
				array(
					'setting'  => 'slider_type',
					'operator' => '==',
					'value'    => 'custom-slider',
				),
			),
		);

		$fields[] = array(
			'type'     => 'text',
			'settings' => 'slider_url_'.$i,
			'label'    => sprintf( __( 'Slide %d Link', 'hitmag' ), $i ),
			'section'  => 'hitmag_pro_slider_settings',
			'default'  => "",
			'priority' => 10,
			'sanitize_callback' => 'esc_url_raw',
			'active_callback'	=> array(
				array(
					'setting'  => 'show_slider',
					'operator' => '==',
					'value'    => true,
				),
				array(
					'setting'  => 'slider_type',
					'operator' => '==',
					'value'    => 'custom-slider',
				),
			),

		);	

	}

	// Blog Options
	$fields[] = array(
		'type'        => 'radio-image',
		'settings'    => 'archive_sidebar_align',
		'label'       => __( 'Content and Sidebar Alignment', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_blog_options',
		'default'     => 'th-right-sidebar',
		'priority'    => 10,
		'option_type' => 'option', 
		'choices'     => array(
			'th-right-sidebar' 		=> get_template_directory_uri() . '/inc/customizer/assets/imgs/2cr.png',
			'th-left-sidebar'   	=> get_template_directory_uri() . '/inc/customizer/assets/imgs/2cl.png',
			'th-no-sidebar'  		=> get_template_directory_uri() . '/inc/customizer/assets/imgs/1c.png',
			'th-content-centered'  	=> get_template_directory_uri() . '/inc/customizer/assets/imgs/1cc.png',
		),
	);

	$fields[] = array(
		'type'        => 'radio',
		'settings'    => 'archive_content_layout',
		'label'       => __( 'Posts Listing Layout', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_blog_options',
		'default'     => 'th-grid-2',
		'priority'    => 10,
		'option_type' => 'option', 		
		'choices'     => array(
			'th-grid-2'   => array(
				esc_attr__( '2 Columns Grid', 'hitmag-pro' ),
				esc_attr__( '2 posts in a row.', 'hitmag-pro' ),
			),
			'th-grid-3' => array(
				esc_attr__( '3 Columns Grid', 'hitmag-pro' ),
				esc_attr__( '3 posts in a row.', 'hitmag-pro' ),
			),
			'th-list-posts'  => array(
				esc_attr__( 'List Posts', 'hitmag-pro' ),
				esc_attr__( 'Posts with featured images on the left side.', 'hitmag-pro' ),
			),
			'th-large-posts'  => array(
				esc_attr__( 'Large Posts', 'hitmag-pro' ),
				esc_attr__( 'Large posts with featured images on the top.', 'hitmag-pro' ),
			),
		),
	);

	$fields[] = array(
		'type'        => 'multicheck',
		'settings'    => 'blog_post_meta',
		'label'       => __( 'What post meta to display?', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_blog_options',
		'default'     => array('categories', 'date', 'author', 'comments'),
		'priority'    => 10,
		'choices'     => array(
			'categories' 	=> esc_attr__( 'Category List', 'hitmag-pro' ),
			'date' 			=> esc_attr__( 'Date', 'hitmag-pro' ),
			'author' 		=> esc_attr__( 'Author', 'hitmag-pro' ),
			'comments' 		=> esc_attr__( 'Comments Link', 'hitmag-pro' ),
		),
	);

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'excerpt_display',
		'label'       => __( 'Excerpt Show/Hide', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_blog_options',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => array(
			'on'  	=> esc_attr__( 'Show', 'hitmag-pro' ),
			'off' 	=> esc_attr__( 'Hide', 'hitmag-pro' ),
		),
	);

	$fields[] = array(
		'type'        => 'number',
		'settings'    => 'excerpt_length',
		'label'       => esc_attr__( 'Excerpt Length', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_blog_options',
		'default'     => 30,
		'choices'     => array(
			'min'  => 0,
			'max'  => 500,
			'step' => 1,
		),
		'active_callback'    => array(
			array(
				'setting'  => 'excerpt_display',
				'operator' => '==',
				'value'    => true,
			),
		),
	);

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'show_readmore',
		'label'       => __( 'Show read more button.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_blog_options',
		'default'     => '1',
		'priority'    => 10,
		'choices'     => array(
			'on'  => esc_attr__( 'Show', 'hitmag-pro' ),
			'off' => esc_attr__( 'Hide', 'hitmag-pro' ),
		),
	);

	$fields[] = array(
		'type'     			=> 'text',
		'settings' 			=> 'readmore_text',
		'label'    			=> __( 'Read more button text.', 'hitmag-pro' ),
		'section'  			=> 'hitmag_pro_blog_options',
		'default'  			=> esc_attr__( 'Read More', 'hitmag-pro' ),
		'priority' 			=> 10,
		'active_callback'	=> array(
			array(
				'setting'  => 'show_readmore',
				'operator' => '==',
				'value'    => true,
			),
		),
	);

	$fields[] = array(
		'type'        => 'radio-image',
		'settings'    => 'post_sidebar_align',
		'label'       => __( 'Content and Sidebar Alignment', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_layout',
		'default'     => 'th-right-sidebar',
		'priority'    => 1,
		'option_type' => 'option', 
		'choices'     => array(
			'th-right-sidebar' 		=> get_template_directory_uri() . '/inc/customizer/assets/imgs/2cr.png',
			'th-left-sidebar'   	=> get_template_directory_uri() . '/inc/customizer/assets/imgs/2cl.png',
			'th-no-sidebar'  		=> get_template_directory_uri() . '/inc/customizer/assets/imgs/1c.png',
			'th-content-centered'  	=> get_template_directory_uri() . '/inc/customizer/assets/imgs/1cc.png',
		),
	);

	$fields[] = array(
		'type'        => 'radio-image',
		'settings'    => 'hitmag_pro_post_template',
		'label'       => __( 'Post template', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_layout',
		'default'     => 'post-style-1',
		'priority'    => 2,
		'option_type' => 'option', 
		'choices'     => array(
			'post-style-1' 	=> get_template_directory_uri() . '/inc/customizer/assets/imgs/style-1.jpg',
			'post-style-2'  => get_template_directory_uri() . '/inc/customizer/assets/imgs/style-2.jpg',
			'post-style-3'  => get_template_directory_uri() . '/inc/customizer/assets/imgs/style-3.jpg',
			'post-style-4'  => get_template_directory_uri() . '/inc/customizer/assets/imgs/style-4.jpg',
		),
	);	

	$fields[] = array(
		'type'        => 'multicheck',
		'settings'    => 'single_post_meta',
		'label'       => __( 'What post meta to display in single post?', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_meta',
		'default'     => array( 'categories', 'date', 'author', 'comments'),
		'priority'    => 1,
		'choices'     => array(
			'categories' 	=> esc_attr__( 'Categories List', 'hitmag-pro' ),
			'date' 			=> esc_attr__( 'Date', 'hitmag-pro' ),
			'author' 		=> esc_attr__( 'Author', 'hitmag-pro' ),
			'comments' 		=> esc_attr__( 'Comments Link', 'hitmag-pro' )
		),
	);	

	$fields[] = array(
		'type'        => 'toggle',
		'settings'    => 'sharing_on_header',
		'label'       => __( 'Show social sharing icons after title', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_sharing',
		'default'     => '1',
		'priority'    => 1,
	);

	$fields[] = array(
		'type'        => 'toggle',
		'settings'    => 'sharing_on_footer',
		'label'       => __( 'Show social sharing icons after content', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_sharing',
		'default'     => '1',
		'priority'    => 2,
	);

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'single_thumbnail_sw',
		'label'       => __( 'Featured image inside the single post.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_thumbnail',
		'default'     => '1',
		'priority'    => 1,
		'choices'     => array(
			'on'  => esc_attr__( 'Show', 'hitmag-pro' ),
			'off' => esc_attr__( 'Hide', 'hitmag-pro' ),
		),
	);	

	$fields[] = array(
		'type'        => 'checkbox',
		'settings'    => 'thumb_link_to_original',
		'label'       => __( 'Link featured image to full size image.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_thumbnail',
		'default'     => '1',
		'priority'    => 2,
		'active_callback'	=> array(
			array(
				'setting'  => 'single_thumbnail_sw',
				'operator' => '==',
				'value'    => true,
			),
		),		
	);	

	$fields[] = array(
		'type'        		=> 'checkbox',
		'settings'    		=> 'use_lightbox',
		'label'       		=> __( 'Use lightbox feature.', 'hitmag-pro' ),
		'section'     		=> 'hitmag_pro_post_thumbnail',
		'default'     		=> '1',
		'priority'    		=> 3,
		'active_callback'	=> array(
			array(
				'setting'  => 'single_thumbnail_sw',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'thumb_link_to_original',
				'operator' => '==',
				'value'    => true,
			),
		),
	);	

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'postsnav_sw',
		'label'       => __( 'Posts navigation after the post.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_navigation',
		'default'     => '1',
		'priority'    => 4,
		'choices'     => array(
			'on'  => esc_attr__( 'Show', 'hitmag-pro' ),
			'off' => esc_attr__( 'Hide', 'hitmag-pro' ),
		),
	);	

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'authorbox_sw',
		'label'       => __( 'Author details box after the post.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_author',
		'default'     => '1',
		'priority'    => 5,
		'choices'     => array(
			'on'  => esc_attr__( 'Show', 'hitmag-pro' ),
			'off' => esc_attr__( 'Hide', 'hitmag-pro' ),
		),
	);	

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'relatedposts_sw',
		'label'       => __( 'Related posts after the post.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_related',
		'default'     => '1',
		'priority'    => 1,
		'choices'     => array(
			'on'  => esc_attr__( 'Show', 'hitmag-pro' ),
			'off' => esc_attr__( 'Hide', 'hitmag-pro' ),
		),
	);	

	$fields[] = array(
		'type'        => 'radio',
		'settings'    => 'related_posts_method',
		'label'       => __( 'Show related posts based on', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_related',
		'default'     => 'category',
		'priority'    => 2,		
		'choices'     => array(
			'category'   => array(
				esc_attr__( 'Post Category.', 'hitmag-pro' )
			),
			'tags' => array(
				esc_attr__( 'Post tags.', 'hitmag-pro' )
			)
		),
	);	

	$fields[] = array(
		'type'        => 'switch',
		'settings'    => 'taglist_sw',
		'label'       => __( 'Tags list after the post.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_post_meta',
		'default'     => '1',
		'priority'    => 7,
		'choices'     => array(
			'on'  => esc_attr__( 'Show', 'hitmag-pro' ),
			'off' => esc_attr__( 'Hide', 'hitmag-pro' ),
		),
	);	

	$fields[] = array(
		'type'        => 'radio-image',
		'settings'    => 'page_sidebar_align',
		'label'       => __( 'Content and Sidebar Alignment', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_page_options',
		'default'     => 'th-right-sidebar',
		'priority'    => 10,
		'option_type' => 'option', 
		'choices'     => array(
			'th-right-sidebar' 		=> get_template_directory_uri() . '/inc/customizer/assets/imgs/2cr.png',
			'th-left-sidebar'   	=> get_template_directory_uri() . '/inc/customizer/assets/imgs/2cl.png',
			'th-no-sidebar'  		=> get_template_directory_uri() . '/inc/customizer/assets/imgs/1c.png',
			'th-content-centered'  	=> get_template_directory_uri() . '/inc/customizer/assets/imgs/1cc.png',
		),
	);

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'site_title_font',
		'label'       => esc_attr__( 'Site Title Font', 'hitmag-pro' ),
		'description' => esc_attr__( 'Select the font for site title. Default font: "Open Sans"', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_typo',
		'default'     => array(
			'font-family'    => 'Open Sans',
			'variant'        => '700',
			'font-size'      => '36px',
			'line-height'    => '1.3',
			'subsets'        => array( 'latin-ext' ),
		),
		'priority'    => 1,
		'output'      => array(
			array(
				'element' => '.site-title',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'body_font',
		'label'       => esc_attr__( 'Body Font', 'hitmag-pro' ),
		'description' => esc_attr__( 'Select the main font for the whole site. Default font: "Lato"', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_typo',
		'default'     => array(
			'font-family'    => 'Lato',
			'variant'        => 'regular',
			'font-size'      => '16px',
			'line-height'    => '1.5',
			'subsets'        => array( 'latin-ext' ),
		),
		'priority'    => 2,
		'output'      => array(
			array(
				'element' => 'body',
			),
		),
	);

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'secondary_font',
		'label'       => esc_attr__( 'Secondary Font', 'hitmag-pro' ),
		'description' => esc_attr__( 'This font applies to main navigation, top navigation, widget titles, archive page titles, buttons and article metadata. Default font: "Ubuntu"', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_typo',
		'default'     => array(
			'font-family'    => 'Ubuntu',
			'variant'        => '700',
			'subsets'        => array( 'latin-ext' ),
		),
		'priority'    => 3,
		'output'      => array(
			array(
				'element' => array( '.main-navigation', '.post-navigation .meta-nav', '.widget-title', '.footer-widget-title', '#hm-tabs .hm-tab-anchor', '.hm-top-bar', '.cat-links', '.arc-page-title', '.srch-page-title'  )
			),
			array(
				'element' => array( 'button, input[type="button"], input[type="reset"], input[type="submit"]', '.th-readmore', '#hm-search-form .search-form .search-submit', 'a.hm-viewall',  )
			),
		),
	);	

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'mainnav_font_size',
		'label'       => esc_attr__( 'Main navigation font size.', 'hitmag-pro' ),
		'description' => esc_attr__( 'Default: 14px', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_typo',
		'default'     => array(
			'font-size'      => '14px',
		),
		'priority'    => 4,
		'output'      => array(
			array(
				'element' => array( '.main-navigation ul' )
			),
		),
	);	

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'heading_tags_font',
		'label'       => esc_attr__( 'Heading Font', 'hitmag-pro' ),
		'description' => esc_attr__( 'font for heading tags( h1, h2, h3, etc ), all article titles and widget article titles. Default font: "Lato"', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_heading_typo',
		'default'     => array(
			'font-family'    => 'Lato',
			'variant'        => '700',
			'subsets'        => array( 'latin-ext' ),
		),
		'priority'    => 1,
		'output'      => array(
			array(
				'element' => array( 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' ),
			),
		),
	);

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'h1_font_size',
		'label'       => esc_attr__( 'H1 Font Size', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_heading_typo',
		'default'     => array(
			'font-size'      => '36px',
		),
		'priority'    => 2,
		'output'      => array(
			array(
				'element' => array( 'h1' )
			),
		),
	);	

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'h2_font_size',
		'label'       => esc_attr__( 'H2 Font Size', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_heading_typo',
		'default'     => array(
			'font-size'      => '32px',
		),
		'priority'    => 3,
		'output'      => array(
			array(
				'element' => array( 'h2' )
			),
		),
	);		

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'h3_font_size',
		'label'       => esc_attr__( 'H3 Font Size', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_heading_typo',
		'default'     => array(
			'font-size'      => '28px',
		),
		'priority'    => 4,
		'output'      => array(
			array(
				'element' => array( 'h3' )
			),
		),
	);		

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'h4_font_size',
		'label'       => esc_attr__( 'H4 Font Size', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_heading_typo',
		'default'     => array(
			'font-size'      => '24px',
		),
		'priority'    => 5,
		'output'      => array(
			array(
				'element' => array( 'h4' )
			),
		),
	);	

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'h5_font_size',
		'label'       => esc_attr__( 'H5 Font Size', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_heading_typo',
		'default'     => array(
			'font-size'      => '20px',
		),
		'priority'    => 6,
		'output'      => array(
			array(
				'element' => array( 'h5' )
			),
		),
	);		

	$fields[] = array(
		'type'        => 'typography',
		'settings'    => 'h6_font_size',
		'label'       => esc_attr__( 'H6 Font Size', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_heading_typo',
		'default'     => array(
			'font-size'      => '16px',
		),
		'priority'    => 7,
		'output'      => array(
			array(
				'element' => array( 'h6' )
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'header_text_hover_color',
		'label'       => __( 'Site Title Text Hover Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_colors',
		'default'     => '#222222',
		'priority'    => 3,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.site-title a:hover',
				'property' 	=> 'color',
			),
		),
	);

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'header_bg_color',
		'label'       => __( 'Header Background Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_colors',
		'default'     => '#ffffff',
		'priority'    => 4,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.site-header',
				'property' 	=> 'background-color',
			),
		),
	);			

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'hitmag_pro_primary_color',
		'label'       => __( 'Theme Main Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_colors',
		'default'     => '#E74C3C',
		'priority'    => 5,
		'choices'     => array(
			'alpha' => true,
		)
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'body_text',
		'label'       => __( 'Body Text Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_colors',
		'default'     => '#404040',
		'priority'    => 6,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> 'body',
				'property' 	=> 'color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'article_title_color',
		'label'       => __( 'Article titles color', 'hitmag-pro' ),
		'description' => __( 'This applies to magazine widgets posts titles, blog post titles, page titles and archive page tiltes.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_colors',
		'default'     => '#222222',
		'priority'    => 7,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.hmb-entry-title a', '.hms-title a', '.hmw-grid-post .post-title a', '.hitmag-post .entry-title a', '.hitmag-single .entry-title', '.hitmag-page .entry-title' ),
				'property' 	=> 'color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'widget_title_color',
		'label'       => __( 'Widget titles color', 'hitmag-pro' ),
		'description' => __( 'This applies to all magazine posts widget titles and sidebar widget titles.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_colors',
		'default'     => '#333333',
		'priority'    => 7,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.widget-title',
				'property' 	=> 'color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'article_meta_color',
		'label'       => __( 'Article metadata color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_main_colors',
		'default'     => '#888888',
		'priority'    => 7,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.hmb-entry-meta, .hms-meta, .hmb-entry-meta a, .hms-meta a', '.hitmag-single .entry-meta', '.hitmag-single .entry-meta a', '.hitmag-post .entry-meta' ,'.hitmag-post .entry-meta a' ),
				'property' 	=> 'color',
			),
		),
	);		

	// Links/Button Colors.

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'article_link_color',
		'label'       => __( 'Article links color', 'hitmag-pro' ),
		'description' => __( 'This applies to links inside articles.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_link_colors',
		'default'     => '#3498DB',
		'priority'    => 1,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> 'a',
				'property' 	=> 'color',
			),
		),
	);

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'article_link_hover_color',
		'label'       => __( 'Article links hover color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_link_colors',
		'default'     => '#e74c3c',
		'priority'    => 2,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> 'a:hover',
				'property' 	=> 'color',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'btn_bg_color',
		'label'       => __( 'Button background color', 'hitmag-pro' ),
		'description' => __( 'This applies for buttons all over the site.', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_link_colors',
		'default'     => '#e74c3c',
		'priority'    => 3,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( 'button', 'input[type="button"]', 'input[type="reset"]', 'input[type="submit"]', 'a.hm-viewall', '.th-readmore','.search-form .search-submit', '#hm-search-form .search-form .search-submit' ),
				'property' 	=> 'background-color',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'btn_text_color',
		'label'       => __( 'Button text color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_link_colors',
		'default'     => '#ffffff',
		'priority'    => 4,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( 'button', 'input[type="button"]', 'input[type="reset"]', 'input[type="submit"]', 'a.hm-viewall', 'a.hm-viewall:visited', '.th-readmore', '.th-readmore:visited', '.search-form .search-submit', '#hm-search-form .search-form .search-submit' ),
				'property' 	=> 'color',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'btn_bg_hover_color',
		'label'       => __( 'Button background hover color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_link_colors',
		'default'     => '#222222',
		'priority'    => 5,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( 'button:hover', 'input[type="button"]:hover', 'input[type="reset"]:hover', 'input[type="submit"]:hover', 'a.hm-viewall:hover', '.th-readmore:hover', '.search-form .search-submit:hover', '#hm-search-form .search-form .search-submit:hover' ),
				'property' 	=> 'background-color',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'btn_text_hover_color',
		'label'       => __( 'Button text hover color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_link_colors',
		'default'     => '#ffffff',
		'priority'    => 6,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( 'button:hover', 'input[type="button"]:hover', 'input[type="reset"]:hover', 'input[type="submit"]:hover', 'a.hm-viewall:hover','.search-form .search-submit:hover', '.th-readmore:hover', '#hm-search-form .search-form .search-submit:hover' ),
				'property' 	=> 'color',
			),
		),
	);		

	// Main navigation
	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'mainnav_bg_color',
		'label'       => __( 'Main Navigation Background Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_mainnav_colors',
		'default'     => '#222222',
		'priority'    => 1,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.main-navigation',
				'property' 	=> 'background-color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'mainnav_text_color',
		'label'       => __( 'Text Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_mainnav_colors',
		'default'     => '#dddddd',
		'priority'    => 2,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.main-navigation a',
				'property' 	=> 'color',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'mainnav_bg_hover_color',
		'label'       => __( 'Hover/Active Background Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_mainnav_colors',
		'default'     => '#E74C3C',
		'priority'    => 3,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.main-navigation a:hover', '.main-navigation .current_page_item > a', '.main-navigation .current-menu-item > a', '.main-navigation .current_page_ancestor > a', '.main-navigation .current-menu-ancestor > a' ),
				'property' 	=> 'background-color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'mainnav_text_hover_color',
		'label'       => __( 'Hover/Active Text Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_mainnav_colors',
		'default'     => '#ffffff',
		'priority'    => 4,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.main-navigation a:hover', '.main-navigation .current_page_item > a', '.main-navigation .current-menu-item > a', '.main-navigation .current_page_ancestor > a', '.main-navigation .current-menu-ancestor > a' ),
				'property' 	=> 'color',
			),
		),
	);	

	// Dropdown	
	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'mainnav_drpdwn_bg_color',
		'label'       => __( 'Main Navigation Dropdown Background Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_mainnav_colors',
		'default'     => '#333333',
		'priority'    => 5,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.main-navigation ul ul',
				'property' 	=> 'background-color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'mainnav_drpdwn_text_color',
		'label'       => __( 'Dropdown Text Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_mainnav_colors',
		'default'     => '#dddddd',
		'priority'    => 6,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.main-navigation ul ul a',
				'property' 	=> 'color',
			),
		),
	);

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'mainnav_drpdwn_bg_hover_color',
		'label'       => __( 'Dropdown Hover/Active Background Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_mainnav_colors',
		'default'     => '#E74C3C',
		'priority'    => 7,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.main-navigation ul ul a:hover', '.main-navigation ul ul .current_page_item > a', '.main-navigation ul ul .current-menu-item > a', '.main-navigation ul ul .current_page_ancestor > a', '.main-navigation ul ul .current-menu-ancestor > a' ),
				'property' 	=> 'background-color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'mainnav_drpdwn_text_hover_color',
		'label'       => __( 'Dropdown Hover/Active Text Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_mainnav_colors',
		'default'     => '#ffffff',
		'priority'    => 8,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.main-navigation ul ul a:hover', '.main-navigation ul ul .current_page_item > a', '.main-navigation ul ul .current-menu-item > a', '.main-navigation ul ul .current_page_ancestor > a', '.main-navigation ul ul .current-menu-ancestor > a' ),
				'property' 	=> 'color',
			),
		),
	);

	// Topbar
	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'topnav_bg_color',
		'label'       => __( 'Top Bar Background Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_topnav_colors',
		'default'     => '#ECF0F1',
		'priority'    => 1,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.hm-top-bar',
				'property' 	=> 'background-color',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'topnav_text_color',
		'label'       => __( 'Top Bar Text / Link Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_topnav_colors',
		'default'     => '#222222',
		'priority'    => 2,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.top-navigation a', '.hm-top-bar' ),
				'property' 	=> 'color',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'topnav_link_hover_color',
		'label'       => __( 'Top Bar Link Hover Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_topnav_colors',
		'default'     => '#e74c3c',
		'priority'    => 3,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.top-navigation a:hover', '.top-navigation .current_page_item > a', '.top-navigation .current-menu-item > a', '.top-navigation .current_page_ancestor > a', '.top-navigation .current-menu-ancestor > a' ),
				'property' 	=> 'color',
			),
		),
	);	

	// Dropdown
	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'topnav_drpdwn_bg_color',
		'label'       => __( 'Top Navigation Dropdown Background Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_topnav_colors',
		'default'     => '#ECF0F1',
		'priority'    => 5,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.top-navigation ul ul',
				'property' 	=> 'background-color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'topnav_drpdwn_text_color',
		'label'       => __( 'Dropdown Text Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_topnav_colors',
		'default'     => '#222222',
		'priority'    => 6,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.top-navigation ul ul a',
				'property' 	=> 'color',
			),
		),
	);

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'topnav_drpdwn_bg_hover_color',
		'label'       => __( 'Dropdown Hover/Active Background Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_topnav_colors',
		'default'     => '#E74C3C',
		'priority'    => 7,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.top-navigation ul ul a:hover', '.top-navigation ul ul .current_page_item > a', '.top-navigation ul ul .current-menu-item > a', '.top-navigation ul ul .current_page_ancestor > a', '.top-navigation ul ul .current-menu-ancestor > a' ),
				'property' 	=> 'background-color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'topnav_drpdwn_text_hover_color',
		'label'       => __( 'Dropdown Hover/Active Text Color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_topnav_colors',
		'default'     => '#ffffff',
		'priority'    => 8,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.top-navigation ul ul a:hover', '.top-navigation ul ul .current_page_item > a', '.top-navigation ul ul .current-menu-item > a', '.top-navigation ul ul .current_page_ancestor > a', '.top-navigation ul ul .current-menu-ancestor > a' ),
				'property' 	=> 'color',
			),
		),
	);	

	// Footer colors.
	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'footer_widget_area_bg',
		'label'       => __( 'Footer widget area background color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_footer_colors',
		'default'     => '#333333',
		'priority'    => 1,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.site-footer',
				'property' 	=> 'background-color',
			),
		),
	);

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'footer_widget_title_color',
		'label'       => __( 'Footer widget title color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_footer_colors',
		'default'     => '#eeeeee',
		'priority'    => 2,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.footer-widget-title',
				'property' 	=> 'color',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'footer_widget_text_color',
		'label'       => __( 'Footer text color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_footer_colors',
		'default'     => '#cccccc',
		'priority'    => 2,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.footer-widget-area', '.footer-widget-area .hmb-entry-summary', '.footer-widget-area .hmb-entry-meta a', '.footer-widget-area .hms-meta a', '.footer-widget-area .hmb-entry-meta', '.footer-widget-area .hms-meta' ),
				'property' 	=> 'color',
			),
		),
	);	

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'footer_widget_link_color',
		'label'       => __( 'Footer link color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_footer_colors',
		'default'     => '#dddddd',
		'priority'    => 3,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.footer-widget-area a', '.footer-widget-area .hmw-grid-post .post-title a', '.footer-widget-area .hmb-entry-title a', '.footer-widget-area .hms-title a' ),
				'property' 	=> 'color',
			),
		),
	);		

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'footer_widget_link_hover_color',
		'label'       => __( 'Footer link hover color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_footer_colors',
		'default'     => '#e74c3c',
		'priority'    => 4,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.footer-widget-area a:hover', '.site-info a:hover', '.footer-widget-area .hmw-grid-post .post-title a:hover', '.footer-widget-area .hmb-entry-title a:hover', '.footer-widget-area .hms-title a:hover', '.footer-widget-area .hmb-entry-meta a:hover', '.footer-widget-area .hms-meta a:hover' ),
				'property' 	=> 'color',
			),
		),
	);

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'footer_copyright_bg_color',
		'label'       => __( 'Footer copyright area background color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_footer_colors',
		'default'     => '#222222',
		'priority'    => 5,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> '.site-info',
				'property' 	=> 'background-color',
			),
		),
	);			

	$fields[] = array(
		'type'        => 'color',
		'settings'    => 'footer_copyright_text_color',
		'label'       => __( 'Footer copyright area text color', 'hitmag-pro' ),
		'section'     => 'hitmag_pro_footer_colors',
		'default'     => '#ffffff',
		'priority'    => 6,
		'choices'     => array(
			'alpha' => true,
		),
		'output'      => array(
			array(
				'element' 	=> array( '.site-info', '.site-info a' ),
				'property' 	=> 'color',
			),
		),
	);		

	return $fields;

}
add_filter( 'kirki/fields', 'hitmag_pro_kirki_fields' );

/**
 * Returns false if Magazine Homepage is activated.
 */
function hitmag_pro_is_active_magazine_homepage() {
	
	if ( 'page' == get_option( 'show_on_front' ) ) {
        
		$frontpage_id = get_option( 'page_on_front' );
        $frontpage_slug = get_page_template_slug( $frontpage_id );

        if ( $frontpage_slug == 'template-magazine.php' ) {
            return true;
        } else {
			return false;
		}

	} else {
		return false;
	}
	
}

function hitmag_pro_inactive_magazine() {
	if ( true == hitmag_pro_is_active_magazine_homepage() ) {
		return false;
	} else {
		return true;
	}
}


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function hitmag_pro_customize_preview_js() {
	wp_enqueue_script( 'hitmag_pro_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'hitmag_pro_customize_preview_js' );

/**
 * Enqueue the customizer stylesheet.
 */
function hitmag_pro_enqueue_customizer_stylesheets() {

    wp_register_style( 'hitmag-pro-customizer-css', get_template_directory_uri() . '/css/customizer.css', NULL, NULL, 'all' );
    wp_enqueue_style( 'hitmag-pro-customizer-css' );
    wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/css/font-awesome.min.css', array(), '4.7.0' );

}
add_action( 'customize_controls_print_styles', 'hitmag_pro_enqueue_customizer_stylesheets' );