<?php

/**
 * Displays latest, category wised posts.
 *
 */

class HitMag_Pro_Single_Category_Posts extends WP_Widget {

	/* Register Widget with WordPress*/
	function __construct() {
		parent::__construct(
			'hitmag_pro_single_category_posts', // Base ID
			__( 'Magazine Posts (Style 1)', 'hitmag-pro' ), // Name
			array( 'description' => __( 'Displays latest posts or posts from a choosen category.', 'hitmag-pro' ), ) // Args
		);
	}


	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		$defaults = array(
			'title'			=>	__( 'Latest Posts', 'hitmag-pro' ),
			'category'		=>	'all',
			'number_posts'	=> 5,
			'sticky_posts' 	=> true,
			'viewall_text'	=> __( 'View All', 'hitmag-pro' )
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
	?>

	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'hitmag-pro' ); ?></label>
		<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>"/>
	</p>
	<p>
		<label><?php _e( 'Select a post category', 'hitmag-pro' ); ?></label>
		<?php wp_dropdown_categories( array( 'name' => $this->get_field_name('category'), 'selected' => $instance['category'], 'show_option_all' => 'Show all posts' ) ); ?>
	</p>
	<p>
		<label for="<?php echo $this->get_field_id( 'number_posts' ); ?>"><?php _e( 'Number of posts:', 'hitmag-pro' ); ?></label>
		<input class="widefat" type="number" id="<?php echo $this->get_field_id( 'number_posts' ); ?>" name="<?php echo $this->get_field_name( 'number_posts' );?>" value="<?php echo absint( $instance['number_posts'] ); ?>" size="3"/> 
	</p>
	<p>
		<input type="checkbox" <?php checked( $instance['sticky_posts'], true ) ?> class="checkbox" id="<?php echo $this->get_field_id('sticky_posts'); ?>" name="<?php echo $this->get_field_name('sticky_posts'); ?>" />
		<label for="<?php echo $this->get_field_id('sticky_posts'); ?>"><?php _e( 'Hide sticky posts.', 'hitmag-pro' ); ?></label>
	</p>	
	<p>
		<label for="<?php echo $this->get_field_id( 'viewall_text' ); ?>"><?php _e( 'View All Text:', 'hitmag-pro' ); ?></label>
		<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'viewall_text' ); ?>" name="<?php echo $this->get_field_name( 'viewall_text' ); ?>" value="<?php echo esc_attr( $instance['viewall_text'] ); ?>"/>
	</p>	

	<?php

	}



	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance[ 'title' ] = sanitize_text_field( $new_instance[ 'title' ] );		
		$instance[ 'category' ]	= absint( $new_instance[ 'category' ] );
		$instance[ 'number_posts' ] = (int)$new_instance[ 'number_posts' ];
		$instance[ 'sticky_posts' ] = (bool)$new_instance[ 'sticky_posts' ];		
		$instance[ 'viewall_text' ] = sanitize_text_field( $new_instance[ 'viewall_text' ] );
		return $instance;
	}


	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	
	public function widget( $args, $instance ) {
		extract($args);

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';	
		$title = apply_filters( 'widget_title', $title , $instance, $this->id_base );
		$category = ( isset( $instance['category'] ) ) ? absint( $instance['category'] ) : '';
		$number_posts = ( ! empty( $instance['number_posts'] ) ) ? absint( $instance['number_posts'] ) : 5; 
		$sticky_posts = ( isset( $instance['sticky_posts'] ) ) ? $instance['sticky_posts'] : true;		
		$viewall_text = ( ! empty( $instance['viewall_text'] ) ) ? $instance['viewall_text'] : '';	
		// Latest Posts
		$latest_posts = new WP_Query( 
			array(
				'cat'					=> $category,
				'posts_per_page'		=> $number_posts,
				'post_status'			=> 'publish',
				'ignore_sticky_posts' 	=> $sticky_posts,
			)
		);	

		echo $before_widget;
		if ( $title ) {
			echo $before_title . $title . $after_title;
		}
	
		hitmag_pro_viewall_link( $category, $viewall_text );
		
		?>

		<div class="hitmag-one-category">
			<?php $hmp_count = 1 ?>
			<?php 
				if ( $latest_posts -> have_posts() ) :
				
				while ( $latest_posts -> have_posts() ) : $latest_posts -> the_post();

					if ( $hmp_count == 1 ) { ?>
					
					<div class="hmb-post">

						<?php if ( has_post_thumbnail() ) { ?>
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
	                        	<div class="hmb-thumb">
	                            	<?php 
	                            		the_post_thumbnail( 'hitmag-grid' ); 

										if ( has_post_format( 'video' ) ) {
											hitmag_pro_show_video_icon( 'large' );
										} 
									?>
								</div>
							</a>
						<?php } ?>

						<?php hitmag_pro_category_list(); ?>

						<?php the_title( '<h3 class="hmb-entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' ); ?>							

						<div class="hmb-entry-meta">
							<?php hitmag_pro_posted_on(); ?>
						</div><!-- .entry-meta -->

						<div class="hmb-entry-summary"><?php the_excerpt(); ?></div>

					</div><!-- .hmb-post -->

					<div class="hms-posts">

				<?php } else { ?>

					<div class="hms-post">
						<?php if ( has_post_thumbnail() ) { ?>
							<div class="hms-thumb">
								<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
									<?php
                                    	the_post_thumbnail( 'hitmag-thumbnail' ); 
										if ( has_post_format( 'video' ) ) {
											hitmag_pro_show_video_icon( 'small' );
										}
									?>
								</a>
							</div>
						<?php } ?>
						<div class="hms-details">
							<?php the_title( sprintf( '<h3 class="hms-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>
							<p class="hms-meta"><?php echo hitmag_pro_posted_datetime(); ?></p>
						</div>
					</div>

				<?php } 
				
				$hmp_count++; 
			endwhile;
			wp_reset_postdata();
			endif; ?>
		
				</div><!-- .hms-posts -->
			</div><!-- .hitmag-one-category -->

	<?php
		echo $after_widget;
	}

}

// Register single category posts widget
function hitmag_pro_register_single_category_posts() {
    register_widget( 'HitMag_Pro_Single_Category_Posts' );
}
add_action( 'widgets_init', 'hitmag_pro_register_single_category_posts' );