<?php
/**
 * Single post template 2
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package HitMag Pro
 */

get_header(); ?>

</div><!-- .hm-container -->

<?php

while ( have_posts() ) : the_post(); ?>

	<?php 
        if ( has_post_thumbnail() ) { 
            $thumb_id               = get_post_thumbnail_id();
            $featured_url_array     = wp_get_attachment_image_src( $thumb_id, 'full' );
            $hero_bg_image_url     = $featured_url_array[0]; 
            $hm_header_class = "hm-img-post-header";
            $hm_hero_container = "";
        } else {
        	$hero_bg_image_url = "";
        	$hm_header_class = "";
        	$hm_hero_container = "hm-no-header-image";
        }
	?>

	<div class="th-hero-container hm-post-style-2 <?php echo esc_attr( $hm_hero_container ); ?>" style="background: url(<?php echo esc_url( $hero_bg_image_url ); ?>);">

		<header class="entry-header <?php echo esc_attr( $hm_header_class ) ?>">
			<div class="hm-header-content">
				<?php
					hitmag_pro_category_list();

					the_title( '<h1 class="entry-title">', '</h1>' );

					if ( 'post' === get_post_type() ) : ?>
					<div class="entry-meta">
						<?php 
							hitmag_pro_posted_on(); 

							$post_view_count = hitmag_pro_post_view_count( $post->ID );
							
							if ( ! empty( $post_view_count ) ) { ?>

								<span class="hm-post-views">
									<i class="fa fa-eye"></i><?php echo intval( $post_view_count ); ?>
								</span>

						<?php } ?>
					</div><!-- .entry-meta -->
					
					<?php endif; ?>
			</div>
		</header>

	</div><!-- .th-hero-container .post-style-2 -->

	<div class="hm-container">

<?php

endwhile;

rewind_posts();

?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php
		while ( have_posts() ) : the_post();

			get_template_part( 'template-parts/content', 'single-template-2' );

			if ( true == get_theme_mod( 'relatedposts_sw', true ) ) :
				get_template_part( 'template-parts/related-posts' );
			endif;

			if ( true == get_theme_mod( 'postsnav_sw', true ) ) :
				the_post_navigation( array(
					'next_text' => '<span class="meta-nav" aria-hidden="true">' . __( 'Next Article', 'hitmag-pro' ) . '</span> ' .
						'<span class="post-title">%title</span>',
					'prev_text' => '<span class="meta-nav" aria-hidden="true">' . __( 'Previous Article', 'hitmag-pro' ) . '</span> ' .
						'<span class="post-title">%title</span>',
				) );
			endif;

			if ( true == get_theme_mod( 'authorbox_sw', true) ) :
				get_template_part( 'template-parts/authorbox' );
			endif;

			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

		endwhile; // End of the loop.
		?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_sidebar();
get_footer();