<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package HitMag Pro
 */ 

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('hitmag-single'); ?>>

	<?php
		if ( true == get_theme_mod( 'sharing_on_header', true ) ) :
			echo hitmag_pro_social_sharing_buttons(); 
		endif;		
	?>

	<div class="entry-content">
		<?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'hitmag-pro' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'hitmag-pro' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php 
			hitmag_pro_entry_footer(); 
			if ( true == get_theme_mod( 'sharing_on_footer', true ) ) :
				echo hitmag_pro_social_sharing_buttons(); 
			endif;
		?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
