<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package HitMag Pro
 */ 

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('hitmag-single'); ?>>

	<?php
		$video_url = get_post_meta( $post->ID, '_hitmag_pro_video_meta', 'true' ); 
		if ( ! empty( $video_url ) ) :
			echo '<div class="hm-video-container">';
				global $wp_embed; 
				echo $wp_embed->run_shortcode( '[embed]' . $video_url . '[/embed]' );
			echo '</div>';
		endif;
	?>

	<header class="entry-header">
		<?php

			hitmag_pro_category_list();

			the_title( '<h1 class="entry-title">', '</h1>' );

		if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php hitmag_pro_posted_on(); ?>

			<?php
				$post_view_count = hitmag_pro_post_view_count( $post->ID );
				if ( ! empty( $post_view_count ) ) { ?>

					<span class="hm-post-views">
						<i class="fa fa-eye"></i><?php echo intval( $post_view_count ); ?>
					</span>

			<?php } ?>


		</div><!-- .entry-meta -->
		<?php
		endif; 

		if ( true == get_theme_mod( 'sharing_on_header', true ) ) :
			echo hitmag_pro_social_sharing_buttons(); 
		endif;

		?>

	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'hitmag-pro' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'hitmag-pro' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php 
			hitmag_pro_entry_footer(); 
			if ( true == get_theme_mod( 'sharing_on_footer', true ) ) :
				echo hitmag_pro_social_sharing_buttons(); 
			endif;
		?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
