<?php 

if ( false == get_theme_mod( 'show_slider', true ) ) { 
    return; 
}

if ( 'posts-slider' == get_theme_mod( 'slider_type', 'posts-slider' ) ) :

    $hm_slider_category = get_theme_mod( 'slider_category', '0' );
    $number_of_slides = get_theme_mod( 'number_of_slides', 5 );

    $slider_posts = new WP_Query (
        array(
            'cat'                   => $hm_slider_category,
            'posts_per_page'        => $number_of_slides,
            'ignore_sticky_posts'   => true
        )
    )

    ?>

    <div class="hitmag-featured-slider">
        <section class="slider">
            <div id="hm-slider" class="flexslider">
                <ul class="slides">
                    <?php
                        if ( $slider_posts->have_posts() ) :
                        while( $slider_posts->have_posts() ) : $slider_posts->the_post();

                        if ( has_post_thumbnail() ) { 
                            $thumb_id               = get_post_thumbnail_id();
                            $featured_url_array     = wp_get_attachment_image_src( $thumb_id, 'hitmag-featured' );
                            $featured_image_url     = $featured_url_array[0]; 
                        } else {
                            $featured_image_url = get_template_directory_uri() . '/images/slide.jpg';
                        }
                    ?>
                        <li>
                            <div class="hm-slider-container" data-loc="<?php echo esc_url( get_permalink() ); ?>">

                                <div class="hm-slide-holder" style="background: url(<?php echo esc_url( $featured_image_url ); ?>);">

                                    <div class="hm-slide-content">

                                        <div class="hm-slider-details">
                                            <?php hitmag_pro_category_list(); ?>

                                            <?php if ( true == get_theme_mod( 'display_slider_title', true ) ) : ?>
                                                <a href="<?php the_permalink(); ?>" rel="bookmark"><h3 class="hm-slider-title"><?php the_title(); ?></h3></a>
                                            <?php endif; ?>

                                            <div class="slide-entry-meta">
                                                <?php hitmag_pro_posted_on( 'slider' ); ?>
                                            </div><!-- .entry-meta -->
                                        </div><!-- .hm-slider-details -->

                                    </div><!-- .hm-slide-content -->

                                </div><!-- .hm-slide-holder -->

                            </div><!-- .hm-slider-container -->
                        </li>

                    <?php 

                        endwhile;
                        endif;

                    ?>
                </ul>
            </div><!-- .flexslider -->
        </section><!-- .slider -->

        <?php $slider_posts->rewind_posts(); ?>

        <div id="hm-carousel" class="flexslider">
            <ul class="slides">
                <?php
                    if ( $slider_posts->have_posts() ) :
                        while( $slider_posts->have_posts() ) : $slider_posts->the_post();

                            if ( has_post_thumbnail() ) { 
                                $thumb_id               = get_post_thumbnail_id();
                                $thumb_url_array        = wp_get_attachment_image_src( $thumb_id, 'hitmag-thumbnail' );
                                $thumb_url              = $thumb_url_array[0];
                            } else {
                                $thumb_url = get_template_directory_uri() . '/images/slide-thumb.jpg';
                            }
                        ?>

                        <li>
                            <div class="hm-thumb-bg"><img src="<?php echo esc_url( $thumb_url ); ?>" /></div>
                        </li>

                    <?php 
                        endwhile; 
                    endif; 
                    wp_reset_postdata(); 
                ?>
            </ul><!-- .slides -->
        </div><!-- #hm-carousel -->

    </div><!-- .hm-slider -->

<?php else : ?>

    <div class="hitmag-featured-slider">
        <section class="slider">
            <div id="hm-slider" class="flexslider">
                <ul class="slides">
                    <?php
                        for ( $i = 1; $i <= 100; $i++ ) {

                            $slide_link = get_theme_mod( 'slider_url_'.$i, '' );
                            $slide_image = get_theme_mod( 'slider_image_'.$i, '' );
                            $slide_title = get_theme_mod( 'slider_title_'.$i, '' );

                            if ( ! empty( $slide_image ) ) :
                    ?>
                            <li>
                                <div class="hm-slider-container">
                                <?php if ( ! empty( $slide_link ) ) : ?>
                                    <a href="<?php echo esc_url( $slide_link ); ?>">
                                <?php endif; ?>
                                    <div class="hm-slide-holder" style="background: url(<?php echo esc_url( $slide_image ); ?>);">

                                        <div class="hm-slide-content">

                                            <div class="hm-slider-details">

                                                <?php if ( ! empty( $slide_title ) ) : ?>

                                                    <h3 class="hm-slider-title"><?php echo esc_html( $slide_title ); ?></h3>

                                                <?php endif; ?>

                                            </div><!-- .hm-slider-details -->

                                        </div><!-- .hm-slide-content -->

                                    </div><!-- .hm-slide-holder -->
                                <?php if ( ! empty( $slide_link ) ) : ?>
                                    </a>
                                <?php endif; ?>
                                </div><!-- .hm-slider-container -->
                            </li>

                    <?php 
                            endif;

                        }

                    ?>
                </ul>
            </div><!-- .flexslider -->
        </section><!-- .slider -->

        <div id="hm-carousel" class="flexslider">
            <ul class="slides">
                <?php
                    for ( $i = 1; $i <= 100; $i++ ) {
                        $slide_image_url = get_theme_mod( 'slider_image_'.$i, '' );

                        if ( ! empty( $slide_image_url ) ) :
                            $thumb_id = hitmag_pro_get_attachment_id( $slide_image_url );
                            $thumb_url_array = wp_get_attachment_image_src( $thumb_id, 'hitmag-thumbnail' );
                            $thumb_url = $thumb_url_array[0];
                        ?>

                        <li>
                            <div class="hm-thumb-bg"><img src="<?php echo esc_url( $thumb_url ); ?>" /></div>
                        </li>

                    <?php 
                        endif;
                    }
                ?>
            </ul><!-- .slides -->
        </div><!-- #hm-carousel -->

    </div><!-- .hm-slider -->

<?php endif; 