<?php
/**
 * Single post template 2
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package HitMag Pro
 */

get_header(); ?>

</div><!-- .hm-container -->

<?php

while ( have_posts() ) : the_post(); ?>

	<div class="th-hero-container post-style-4">
		<?php 
			$video_url = get_post_meta( $post->ID, '_hitmag_pro_video_meta', 'true' ); 
			if ( ! empty( $video_url ) ) :
				echo '<div class="th-hero-video">';
					global $wp_embed; 
					echo $wp_embed->run_shortcode( '[embed width="800"]' . esc_url( $video_url ) . '[/embed]' );
				echo '</div>';
			endif;
		?>
	</div>

	<div class="hm-container">

<?php

endwhile;

rewind_posts();

?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php
		while ( have_posts() ) : the_post();

			get_template_part( 'template-parts/content', 'single' );

			if ( true == get_theme_mod( 'relatedposts_sw', true ) ) :
				get_template_part( 'template-parts/related-posts' );
			endif;

			if ( true == get_theme_mod( 'postsnav_sw', true ) ) :
				the_post_navigation( array(
					'next_text' => '<span class="meta-nav" aria-hidden="true">' . __( 'Next Article', 'hitmag-pro' ) . '</span> ' .
						'<span class="post-title">%title</span>',
					'prev_text' => '<span class="meta-nav" aria-hidden="true">' . __( 'Previous Article', 'hitmag-pro' ) . '</span> ' .
						'<span class="post-title">%title</span>',
				) );
			endif;

			if ( true == get_theme_mod( 'authorbox_sw', true) ) :
				get_template_part( 'template-parts/authorbox' );
			endif;

			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

		endwhile; // End of the loop.
		?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php
get_sidebar();
get_footer();