<?php

/**
 * Displays latest, category wised posts.
 *
 */

class HitMag_Pro_Image_Grid_Posts extends WP_Widget {

	/* Register Widget with WordPress*/
	function __construct() {
		parent::__construct(
			'hitmag_pro_image_grid_posts', // Base ID
			__( 'Magazine Posts ( Image grid )', 'hitmag-pro' ), // Name
			array( 'description' => __( 'Displays posts in a stylish image grid.', 'hitmag-pro' ), ) // Args
		);
	}


	/**
	 * Back-end widget form.
	 *
	 * @see WP_Widget::form()
	 *
	 * @param array $instance Previously saved values from database.
	 */
	public function form( $instance ) {
		$defaults = array(
			'title'			=>	__( 'Latest Posts', 'hitmag-pro' ),
			'category'		=>	'all',
			'viewall_text'	=> __( 'View All', 'hitmag-pro' )
		);
		$instance = wp_parse_args( (array) $instance, $defaults );
	?>

	<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'hitmag-pro' ); ?></label>
		<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>"/>
	</p>
	<p>
		<label><?php _e( 'Select a post category', 'hitmag-pro' ); ?></label>
		<?php wp_dropdown_categories( array( 'name' => $this->get_field_name('category'), 'selected' => $instance['category'], 'show_option_all' => 'Show all posts' ) ); ?>
	</p>
	<p>
		<label for="<?php echo $this->get_field_id( 'viewall_text' ); ?>"><?php _e( 'View All Text:', 'hitmag-pro' ); ?></label>
		<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'viewall_text' ); ?>" name="<?php echo $this->get_field_name( 'viewall_text' ); ?>" value="<?php echo esc_attr( $instance['viewall_text'] ); ?>"/>
	</p>	

	<?php

	}



	/**
	 * Sanitize widget form values as they are saved.
	 *
	 * @see WP_Widget::update()
	 *
	 * @param array $new_instance Values just sent to be saved.
	 * @param array $old_instance Previously saved values from database.
	 *
	 * @return array Updated safe values to be saved.
	 */
	
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance[ 'title' ] = sanitize_text_field( $new_instance[ 'title' ] );		
		$instance[ 'category' ]	= absint( $new_instance[ 'category' ] );
		$instance[ 'viewall_text' ] = sanitize_text_field( $new_instance[ 'viewall_text' ] );
		return $instance;
	}


	/**
	 * Front-end display of widget.
	 *
	 * @see WP_Widget::widget()
	 *
	 * @param array $args     Widget arguments.
	 * @param array $instance Saved values from database.
	 */
	
	public function widget( $args, $instance ) {
		extract($args);

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';	
		$title = apply_filters( 'widget_title', $title , $instance, $this->id_base );
		$category = ( isset( $instance['category'] ) ) ? absint( $instance['category'] ) : '';
		$viewall_text = ( ! empty( $instance['viewall_text'] ) ) ? $instance['viewall_text'] : '';	
		// Latest Posts
		$latest_posts = new WP_Query( 
			array(
				'cat'					=> $category,
				'posts_per_page'		=> 5,
				'post_status'			=> 'publish',
				'ignore_sticky_posts' 	=> true,
			)
		);	

		echo $before_widget;
		if ( $title ) {
			echo $before_title . $title . $after_title;
		}
	
		hitmag_pro_viewall_link( $category, $viewall_text );
		
		?>

		<div class="hitmag-imagegird-posts">

			<div class="hmig-col">
			<?php 

				$hmp_count = 1;

				if ( $latest_posts -> have_posts() ) :
				
				while ( $latest_posts -> have_posts() ) : $latest_posts -> the_post(); 


		            if ( has_post_thumbnail() ) { 
                        $thumb_id               = get_post_thumbnail_id();
                        $featured_url_array     = wp_get_attachment_image_src( $thumb_id, 'full' );
                        $featured_image_url     = esc_url( $featured_url_array[0] ); 
                        $hmig_style 			= "background: url( $featured_image_url );";
                    } else {
                        $hmig_style = "";
                    }

					$item_class = "hmig-post hmig-post-item-{$hmp_count}";

					?>
					
					
					<div class="<?php echo esc_attr( $item_class ); ?>" style="<?php echo esc_attr($hmig_style); ?>">
						<a class="hmig-link" href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"></a>
						<div class="hmig-details">

							<?php hitmag_pro_category_list(); ?>

							<?php the_title( '<h3 class="hmig-slider-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' ); ?>							
							<div class="hmig-entry-meta">
								<?php hitmag_pro_posted_on(); ?>
							</div><!-- .entry-meta -->

						</div>

					</div><!-- .hmig-post -->
					
					<?php 

					if ( $hmp_count == 2 ) {
						echo '</div><div class="hmig-col">';
					}

				$hmp_count++; 
				endwhile;
				wp_reset_postdata();
			endif; ?>

				</div><!--.hmig-col-->
		
			</div><!-- .hitmag-one-category -->

	<?php
		echo $after_widget;
	}

}

// Register single category posts widget
function hitmag_pro_register_image_grid_posts() {
    register_widget( 'HitMag_Pro_Image_Grid_Posts' );
}
add_action( 'widgets_init', 'hitmag_pro_register_image_grid_posts' );