<?php

function hitmag_pro_ajax_scripts() {
	wp_enqueue_script( 'hitmag-front', get_template_directory_uri() . '/js/hitmag-front.js', array('jquery'), null, true );
	wp_localize_script( 'hitmag-front', 'hitmag_ajax_object', 
		array( 
			'ajaxurl' 	=> admin_url( 'admin-ajax.php' )
		) 
	);
}
add_action( 'wp_enqueue_scripts', 'hitmag_pro_ajax_scripts' );


function hitmag_pro_get_ajax_excerpt() {
	$excerpt = wp_strip_all_tags( get_the_excerpt() );
	$num_words = get_theme_mod( 'excerpt_length', 30 );
	$excerpt = wp_trim_words( $excerpt, $num_words, $more = null );
	return $excerpt;
}

function hitmag_pro_ajax_pagination( $ajax_parameters ) { ?>
	<div class="hmp-pagination-data" data-currentpage="<?php echo $ajax_parameters['hm_current_page']; ?>" data-blockuid="<?php echo $ajax_parameters['hm_block_uid']; ?>" data-hmcat="<?php echo $ajax_parameters['hm_category']; ?>" data-hmppp="<?php echo $ajax_parameters['hm_posts_per_page']; ?>">
		
		<?php $disabled_prev = ( $ajax_parameters['hm_show_prev'] == false ) ? 'disabled' : ''; ?>
		<button class="hmajax-btn prev" data-hmnextprev="prev" <?php echo $disabled_prev; ?>><i class="fa fa-angle-left"></i></button>
		
		<?php $disabled_next = ( $ajax_parameters['hm_show_next'] == false ) ? 'disabled' : ''; ?>
		<button class="hmajax-btn next" data-hmnextprev="next"  <?php echo $disabled_next; ?>><i class="fa fa-angle-right"></i></button>
	</div>
	<?php
}

function hitmag_pro_get_wp_query() {

	$widget_id = esc_attr( $_POST['blockuid'] );
	$category_id = ( ! empty( $_POST['hmwCategory'] ) ) ? absint( $_POST['hmwCategory'] ) : '';
	$requested_page = ( ! empty( $_POST['hmwPaged'] ) ) ? absint( $_POST['hmwPaged'] ) : 1;
	$hm_current_page = $requested_page;
	$hm_posts_per_page = ( ! empty( $_POST['hmwPostsPerPage'] ) ) ? absint( $_POST['hmwPostsPerPage'] ) : 5;
	$widget_class_str = explode( '-', $widget_id );
	$widget_class = implode('_', array_map( ucfirst, explode('_', $widget_class_str[0] ) ) );

	if( $hm_posts_per_page > 10 ) {
		$hm_posts_per_page = 10;
	}
	
	$latest_posts = new WP_Query( 
		array(
			'cat'					=> $category_id,
			'posts_per_page'		=> $hm_posts_per_page,
			'post_status'			=> 'publish',
			'ignore_sticky_posts' 	=> 1,
			'paged'					=> $requested_page
		)
	);	

	if( $latest_posts->max_num_pages <= $hm_current_page) {
		$show_next = false;
	} else {
		$show_next = true;
	}

	if( $hm_current_page > 1 ) {
		$show_prev = true;
	}

	if( $hm_current_page == 1 ) {
		$show_prev = false;
		$show_next = true;
	}

	$ajax_parameters = array(
		'hm_block_uid' 		=> $widget_id,
		'hm_category'		=> $category_id,
		'hm_posts_per_page'	=> $hm_posts_per_page,
		'hm_current_page'	=> $hm_current_page,
		'hm_show_next'		=> $show_next,
		'hm_show_prev'		=> $show_prev
	);

	if( class_exists( $widget_class ) ) {
		$widget_class::render_view( $latest_posts, $ajax_parameters, true );
	}

	wp_die();
	
}
add_action( 'wp_ajax_hitmag_pro_get_wp_query', 'hitmag_pro_get_wp_query' );
add_action( 'wp_ajax_nopriv_hitmag_pro_get_wp_query', 'hitmag_pro_get_wp_query' );